
#include <stdio.h>
#include <stdlib.h>
#include "miracl/miracl.h"
#include "rigup.h"

static void usage()
{
  puts("Usage: rigup break PUBLICKEY");
  puts("");
  puts("Breaks a Rigol ECDS public key and calculates");
  puts("correspong private key");
  puts("");
  puts("    PUBLICKEY       public key to break as hex string");
  puts("");
  exit(0);
}

int main_breakecds(int argc, char *argv[])
{
  if (argc != 2)
    usage();

  const char *publicKey = argv[1];

  char *privateKey = BreakECDS(0, publicKey);
  puts(privateKey);
  puts("");
  free(privateKey);

  return 0;
}
