
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>
#include <memory.h>
#include "openssl/rc5.h"
#include "miracl/miracl.h"
#include "rigup.h"

// ECC parameters
char A[] = "2982"; //0ff: confirmed @0x3EE07EC
char B[] = "3408"; //0ff: confirmed @0x3EE07F0
char P[] = "AEBF94CEE3E707"; //0ff: confirmed @0xFCD1C // 1FA8BDF4B8C95545
char N[] = "AEBF94D5C6AA71"; //0ff: confirmed @0xFCD24 // 29B566E6B8C95545
char Gx[] = "7A3E808599A525"; //0ff: confirmed @0xFCD2C // 938633C4886A5405
char Gy[] = "28BE7FAFD2A052"; //0ff: tbc, can somehow be derived from Gx


#if 1
//original map
	static char *charMapDecode = "ARBC3FGHJK96NEQDSMPVWXLZ2U45T87Y";
	/*
		ABCDEFGH234JKLMNPQR567STUVWXYZ89
		LRE8YFGHJK9SNBQ36MPVWXAZ2U45TC7D
		XBCNEF8HJ3LMKPZRSAUVWTYQ5D4276G9

		ABCDEFGH234JKLMNPQR567STUVWXYZ89
		ARBC3FGHJK96NEQDSMPVWXLZ2U45T87Y

	 */
	static char *charMapEncode = "ARBC3FGHJK96NEQDSMPVWXLZ2U45T87Y"; //0ff: confirmed.
#else
//custom map
	static char *charMapDecode = "1977E6D7F81BEF5AC3EB1325391020B6";
	static char *charMapEncode = "E4B7B905D31FB80EA9E7B495DE3EDEBD";
#endif


uint32_t DecodeChar(char value)
{
	char *charPos = strchr(charMapDecode, value);
	return charPos == NULL ? 0 : charPos - charMapDecode;
}

uint64_t ExtractPadding(uint64_t value)
{
  int shiftCount = value & 0x0f;
  uint64_t mask = 0xffffffffffffffff;
  do mask <<= 4; while(shiftCount-- > 0);
  return value & ~mask;
}

uint64_t DecodeSignature(uint64_t value)
{
	uint32_t shiftCount = value & 0x0f;
	do value >>= 4; while(shiftCount-- > 0);
	return value;
}

int DecodeLicenseCode(LicenseData *licenseData, const char *licenseCode, const KeyData *keydata)
{
	if (!licenseData || ! licenseCode || !keydata)
		return 0;

	if(strlen(licenseCode) != LICENSE_CODE_LENGTH)
		return 0;

	/*uint8_t licenseBits[] = {
		0xD, 0x1, 
		0x0, 0x3, 
		0xC, 0x8, 
		0x2, 0x8, 
		0x9, 0x4, 
		0x3, 0x6, 
		0xD, 0x3, 
		0x9, 0xA, 
		0x1, 0x6, 
		0x2, 0x3, 
		0xC, 0x7, 
		0x0, 0x8, 
		0x6, 0xB, 
		0x2, 0x2, 
		0x6, 0x7, 
		0x7, 0x4,

		// this is not swapped?
		0x2, 0x3,
		// last bit is 0x1 for official, 0x9 for trial
		0x9};*/
	uint8_t licenseBits[35];
	// char *licenseBitsStr = "D103C8289436D39A1623C7086B226774239";//lic_code_map(licenseCode);
	// char *licenseBitsStr = lic_code_map(licenseCode);
	for(int i = 0, j = 0; i < LICENSE_CODE_LENGTH; i += 4, j += 5)
	{
		uint32_t bitBuffer =
			(DecodeChar(licenseCode[i]) << 15) +
			(DecodeChar(licenseCode[i+1]) << 10) +
			(DecodeChar(licenseCode[i+2]) << 5) +
			DecodeChar(licenseCode[i+3]);

		licenseBits[j] = bitBuffer >> 16;
		licenseBits[j+1] = (bitBuffer >> 12) & 0xf;
		licenseBits[j+2] = (bitBuffer >> 8) & 0xf;
		licenseBits[j+3] = (bitBuffer >> 4) & 0xf;
		licenseBits[j+4] = bitBuffer & 0xf;
	}
	

	// printf("licenseBits: '");
	// for(int i = 0; i < 35; i++) {
	// 	// licenseBits[i] = char_to_hex(licenseBitsStr[i]);
 //        printf("%02x", licenseBits[i]);
 //    }

	// printf("'\n");

	// // 0ff: validated from here!

	uint64_t RC5Block1 = 0;
	uint64_t RC5Block2 = 0;

	for(int i = 0; i < 16; i++)
	{
		RC5Block1 |= (uint64_t)(licenseBits[i]) << i*4;
		RC5Block2 |= (uint64_t)(licenseBits[i + 16]) << i*4;
	}
	// printf("RC5Block1: 0x%016llx %d\n", RC5Block1, RC5Block1 == 0xA93D6349828C301D);
	// printf("RC5Block2: 0x%016llx %d\n", RC5Block2, RC5Block2 == 0x477622B6807C3261);

	// RC5Block1 = 0xA93D6349828C301D; // 1D308C8249633DA9
	// RC5Block2 = 0x477622B6807C3261; // 61327C80B6227647


	// // 0ff: validated from here!
	uint8_t RC5Key1[16], RC5Key2[16];
	RC5_32_KEY RC5Key;

	ParseHex(RC5Key1, 16, keydata->RC5Key1);
	RC5_32_set_key(&RC5Key, 16, RC5Key1, 0x0C);
	RC5_32_ecb_encrypt((uint8_t*)&RC5Block1, (uint8_t*)&RC5Block1, &RC5Key, 0);

	ParseHex(RC5Key2, 16, keydata->RC5Key2);
	RC5_32_set_key(&RC5Key, 16, RC5Key2, 16);
	RC5_32_ecb_encrypt((uint8_t*)&RC5Block2, (uint8_t*)&RC5Block2, &RC5Key, 1);
	
	// printf("RC5Key1: 0x");
	for(int i = 0; i < 16; i++) {
		printf("%02x", RC5Key1[i]);
	}
	
	// printf("\nRC5Key2: 0x");
	for(int i = 0; i < 16; i++) {
		printf("%02x", RC5Key2[i]);
	}

	// printf("\nRC5Block1 out: 0x%016llx %d\n", RC5Block1, RC5Block1 == 0xC00868ED5DFB3FEB);
	// printf("RC5Block2 out: 0x%016llx %d\n", RC5Block2, RC5Block2 == 0x376A08318629D010);

	// RC5Block1 = 0xC00868ED5DFB3FEB; // endianess swapped EB3FFB5DED6808C0
	// RC5Block2 = 0x376A08318629D010; // endianess swapped 10D0298631086A37


	// // 0ff: validated from here!
	// printf("RC5Block1: 0x%016llx\n", RC5Block1);
	// printf("RC5Block2: 0x%016llx\n", RC5Block2);
	
	// ECDSA signature
	uint64_t sig1 = (RC5Block2 >> 8) | ((uint64_t)(licenseBits[33]) << 56);
	uint64_t sig2 = ((RC5Block1 & 0xffffffffffff) << 8) | (RC5Block2 & 0xff) | ((uint64_t)(licenseBits[32]) << 56);

	// printf("sig1: 0x%016llx\n", sig1);
	// printf("sig2: 0x%016llx\n", sig2);

	licenseData->pad1 = ExtractPadding(sig1);
	licenseData->pad2 = ExtractPadding(sig2);

	licenseData->sig1 = DecodeSignature(sig1);
	licenseData->sig2 = DecodeSignature(sig2);

	// option bits
	licenseData->optionBits = (uint32_t)(RC5Block1 >> 48) | ((uint32_t)(licenseBits[34]) << 16);

	return 1;
}

char* EncodeOptionBits(uint32_t optionBits)
{
	char *optionString = malloc(5); // new char[5];

	for(int i = 0; i < 4; i++)
		optionString[i] = charMapEncode[(optionBits >> ((3-i)*5)) & 0x1f];

	optionString[4] = '\0';
	return optionString;
}

char* EncodeSerialNumber(KeyData *keydata)
{
	// if(strlen(serialNumber) < 4)
	// 	return 0;

	// uint32_t header = *((uint32_t*)serialNumber);

	// for(int i = 0; i < 16; i++)
	// 	header =
	// 		((header << 1) | (header >> 31)) ^
	// 		((header >> 30) & 1) ^
	// 		((header >> 28) & 1) ^
	// 		((header >> 22) & 1) ^
	// 		((header >> 13) & 1) ^
	// 		((header >> 6) & 1);

	// char* result = strdup(serialNumber);
	// *((uint32_t*)result) = header;
	
	return keydata->serialNumber;
}

#define DELTA 0x9e3779b9
#define MX (((z>>5^y<<2) + (y>>3^z<<4)) ^ ((sum^y) + (key[(p&3)^e] ^ z)))

void XXTEA(uint32_t *v, int n, uint32_t const key[4])
{
	uint32_t y, z, sum;
	unsigned p, rounds, e;

	if (n > 1)
	{
		rounds = 6 + 52/n;
		sum = 0;
		z = v[n-1];
		do {
			sum += DELTA;
			e = (sum >> 2) & 3;
			for (p=0; p<n-1; p++)
			{
				y = v[p+1];
				z = v[p] += MX;
			}
			y = v[0];
			z = v[n-1] += MX;
		} while (--rounds);
	}
	else if (n < -1)
	{
		n = -n;
		rounds = 6 + 52/n;
		sum = rounds*DELTA;
		y = v[0];
		do {
			e = (sum >> 2) & 3;
			for (p=n-1; p>0; p--)
			{
				z = v[p-1];
				y = v[p] -= MX;
			}
			z = v[n-1];
			y = v[0] -= MX;
		} while ((sum -= DELTA) != 0);
	}
}

uint64_t ByteSwap64(uint64_t value)
{
	uint64_t result = 0;
	for(int i = 0; i < 8; i++)
	{
		result = (result << 8) | (value & 0xff);
		value >>= 8;
	}
	return result;
}

int VerifySignature(uint64_t sig1, uint64_t sig2, uint8_t signatureDataHash[20], const char *publicKey)
{
	big p = mirvar(0);
	big n = mirvar(0);
	big a = mirvar(0);
	big b = mirvar(0);
	big x = mirvar(0);
	big y = mirvar(0);
	big lic1 = mirvar(0);
	big lic2 = mirvar(0);
	big hash = mirvar(0);
	big m1 = mirvar(0);
	big m2 = mirvar(0);
	big v = mirvar(0);
	big g = mirvar(0);

	epoint *pt1 = epoint_init();
	epoint *pt2 = epoint_init();

	instr(a, A);
	instr(b, B);
	instr(p, P);
	instr(n, N);

	ecurve_init(a, b, p, MR_PROJECTIVE);

	instr(x, Gx);
	instr(y, Gy);
	if (!epoint_set(x, y, 0, pt1))
	{
		printf("ERR: Point G is invalid\n");
		exit(-1);
	}

	instr(x, (char *)publicKey);
	if (!epoint_set(x, x, 1, pt2))
	{
		printf("ERR: Public key is invalid\n");
		exit(-1);
	}

	bytes_to_big(20, (char*)signatureDataHash, hash);

	sig1 = ByteSwap64(sig1);
	bytes_to_big(8, (char*)&sig1, lic1);

	sig2 = ByteSwap64(sig2);
	bytes_to_big(8, (char*)&sig2, lic2);

	xgcd(lic2, n, lic2, lic2, lic2);
	copy(lic2, g);
	mad(hash, g, g, n, n, m1);
	mad(lic1, g, g, n, n, m2);
	ecurve_mult2(m1, pt1, m2, pt2, pt1);
	epoint_get(pt1, v, v);
	divide(v, n, n);

	return mr_compare(v, lic1) == 0;
}

int VerifyLicenseCode(const char *licenseCode, const KeyData *keydata)
{
	LicenseData licenseData;
	DecodeLicenseCode(&licenseData, licenseCode, keydata);

	char *optionString = EncodeOptionBits(licenseData.optionBits);
	char *encodedSerialNumber = EncodeSerialNumber(keydata);

	uint32_t optionStringLength = strlen(optionString);
	uint32_t encodedSerialNumberLength = strlen(encodedSerialNumber);

	uint32_t signatureDataLength = (encodedSerialNumberLength + optionStringLength + 16);
	uint8_t *signatureData = malloc(signatureDataLength);

	memset(signatureData, 0, signatureDataLength);
	memcpy(signatureData, encodedSerialNumber, encodedSerialNumberLength);
	memcpy(signatureData + encodedSerialNumberLength, optionString, optionStringLength);

	uint8_t XXTEAKey[16];
	ParseHex(XXTEAKey, 16, keydata->XXTEAKey);
	// for (int i = 0; i < 16; ++i)
	// {
	// 	// printf("%02x", XXTEAKey[i]);
	// 	signatureData[signatureDataLength + encodedSerialNumberLength + optionStringLength + i] = XXTEAKey[i];
	// }
	memcpy(signatureData + encodedSerialNumberLength + optionStringLength, XXTEAKey, 16);
	
	/*
		int len = strlen(keydata->serialNumber);
		char result[256];
		memset(result, 0, 256);


		uint8_t XXTEAKey[16];
		ParseHex(XXTEAKey, 16, keydata->XXTEAKey);

		printf("Enc: '%s'\n", keydata->serialNumber);

		printf("Enc: '");
		for (int i = 0; i < 16; ++i)
		{
			printf("%02x", XXTEAKey[i]);
		}

		// printf("' '%s'\n", XXTEAKey);
		// sprintf(result, len+16, "%s%16xll", keydata->serialNumber, XXTEAKey);
		
		printf("'\nEnc: '%s'\n", result);

	 */
	
	// printf("Hashing: '%s' (%d, %d) -> '", signatureData, strlen(signatureData), signatureDataLength);
	// XXTEA((uint32_t*)signatureData, signatureDataLength >> 2, (uint32_t*)XXTEAKey);

	uint8_t hash[20];
	sha sh;
	shs_init(&sh);
	for(int i = 0; i < signatureDataLength; i++) {
		// printf("%02x\n", signatureData[i]);
		shs_process(&sh, signatureData[i]);
	}
	shs_hash(&sh, (char*)hash);

	// for (int i = 0; i < 20; ++i)
	// {
	// 	printf("%02x", hash[i]);
	// }
	// printf("'\n");

	return VerifySignature(licenseData.sig1, licenseData.sig2, hash, keydata->publicKey);
}


void PrintLicenseInfo(const char *licenseCode, const KeyData *keydata)
{
  LicenseData licenseData;
  DecodeLicenseCode(&licenseData, licenseCode, keydata);

  int verified = VerifyLicenseCode(licenseCode, keydata);
  char *optionString = EncodeOptionBits(licenseData.optionBits);
  char *pretty = PrettyLicenseCode(licenseCode);

  // if (verified)
    printf("License:        %s    (%s = 0x%05X)\n", pretty, optionString, licenseData.optionBits);
  // else
  //   printf("License:        %s    (____ = _______)\n", pretty);

  printf("Signature 1:    %016lX\n", licenseData.sig1);
  printf("Signature 2:    %016lx\n", licenseData.sig2);
  printf("Padding 1:      %016lX\n", licenseData.pad1);
  printf("Padding 2:      %016lX\n", licenseData.pad2);
  printf("Verify:         %s\n", verified ? "Ok" : "--- FAILED ---");

  free(pretty);
  free(optionString);
}
