
#include <assert.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "rigup.h"
#include "commands.h"

static long maxTries = 0;
static long long tries = 0;
extern char charMap[];

/* Function to swap values at two pointers */
void swap (char *x, char *y)
{
    char temp;
    temp = *x;
    *x = *y;
    *y = temp;
}
  
/* Function to print permutations of string
   This function takes three parameters:
   1. String
   2. Starting index of the string
   3. Ending index of the string. */
void permute(char *a, int i, int n, KeyData* keydata, uint32_t optionBits) 
{
    int j; 
    if (i == n) {
        strcpy(charMap, a);

        if(tries % 10000 == 0) {
            printf("Trying: %s %d\r", charMap, tries);
            fflush(stdout);
        }
        tries++;
        if(!strncmp(CreateLicenseCode(optionBits, keydata), "U2MLNYFW584R5FANJJG9VA4ZSACM", 28)) {
            printf("\nfound! %s %s\n", CreateLicenseCode(optionBits, keydata), charMap);
            exit(0);
        }
        // if(--maxTries == 0) {
        //     printf("\nNo key found, sorry.\n");
        //     exit(0);
        // }
    }
    else
    {
        for (j = i; j <= n; j++)
       {
          swap((a+i), (a+j));
          permute(a, i+1, n, keydata, optionBits);
          swap((a+i), (a+j)); //backtrack
       }
    }
}

void perm_start(char n[], unsigned int count) {
    unsigned int i;
    for (i=0; i<count; i++)
        n[i] = i;
}

//Returns 0 on wraparound
int perm_next(char* n, unsigned int count) {
    unsigned int tail, i, j;

    if (count <= 1)
        return 0;

    /* Find all terms at the end that are in reverse order.
       Example: 0 3 (5 4 2 1) (i becomes 2) */
    for (i=count-1; i>0 && n[i-1] >= n[i]; i--);
    tail = i;

    if (tail > 0) {
        /* Find the last item from the tail set greater than
            the last item from the head set, and swap them.
            Example: 0 3* (5 4* 2 1)
            Becomes: 0 4* (5 3* 2 1) */
        for (j=count-1; j>tail && n[j] <= n[tail-1]; j--);

        swap((n+tail-1), (n+j));
    }

    /* Reverse the tail set's order */
    for (i=tail, j=count-1; i<j; i++, j--)
        swap((n+i), (n+j));

    /* If the entire list was in reverse order, tail will be zero. */
    return (tail != 0);
}

// int perm_t(void)
// {
//     #define N 3
//     char perm[] = "ABC";

//     // perm_start(perm, N);
//     do {
//         int i;
//         for (i = 0; i < N; i++)
//             printf("%c ", perm[i]);
//         printf("\n");
//     } while (perm_next(perm, N));

//     return 0;
// }

char map_20688_2[]={ 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,  /* 0-9 = 0x30 */
                   0x37, 0x37, 0x37, 0x37, 0x37, 0x37 }; 


uint8_t* lic_to_bits(char* licenseCode) {
    uint8_t licenseBits[35];

    for(int i = 0, j = 0; i < LICENSE_CODE_LENGTH; i += 4, j += 5)
    {
        uint32_t bitBuffer =
            (DecodeChar(licenseCode[i]) << 15) +
            (DecodeChar(licenseCode[i+1]) << 10) +
            (DecodeChar(licenseCode[i+2]) << 5) +
            DecodeChar(licenseCode[i+3]);

        printf("i=%d, j=%d, 0x%08x ", i, j, bitBuffer);

        licenseBits[j] = bitBuffer >> 16;
        licenseBits[j+1] = (bitBuffer >> 12) & 0xf;
        licenseBits[j+2] = (bitBuffer >> 8) & 0xf;
        licenseBits[j+3] = (bitBuffer >> 4) & 0xf;
        licenseBits[j+4] = bitBuffer & 0xf;

        printf("%02x ", licenseBits[j]);
        printf("%02x ", licenseBits[j+1]);
        printf("%02x ", licenseBits[j+2]);
        printf("%02x ", licenseBits[j+3]);
        printf("%02x \n", licenseBits[j+4]);
    }

    for(int j = 0; j < 35; j+=5) {
        printf("%02x ", licenseBits[j]);
        printf("%02x ", licenseBits[j+1]);
        printf("%02x ", licenseBits[j+2]);
        printf("%02x ", licenseBits[j+3]);
        printf("%02x \n", licenseBits[j+4]);
    }

    return licenseBits;
}

char* bits_to_lic(uint8_t* licenseBits) {
    char *licenseCode = malloc(LICENSE_CODE_LENGTH + 1);

    for(int i = 0, j = 0; i < LICENSE_CODE_LENGTH; i += 4, j += 5)
    {
      uint32_t bitBuffer =
      ((uint32_t)(licenseBits[j]) & 0x0f) << 16
    | ((uint32_t)(licenseBits[j+1]) & 0x0f) << 12
    | ((uint32_t)(licenseBits[j+2]) & 0x0f) << 8
    | ((uint32_t)(licenseBits[j+3]) & 0x0f) << 4
    | ((uint32_t)(licenseBits[j+4]) & 0x0f);

      licenseCode[i] = EncodeChar(bitBuffer >> 15);
      licenseCode[i+1] = EncodeChar(bitBuffer >> 10);
      licenseCode[i+2] = EncodeChar(bitBuffer >> 5);
      licenseCode[i+3] = EncodeChar(bitBuffer);

      printf("%02x (%c) %02x (%d) %02x (%c) \n", licenseCode[i], licenseCode[i], (bitBuffer >> 15) +1, (bitBuffer >> 15) + 1, EncodeChar(bitBuffer >> 15), EncodeChar(bitBuffer >> 15));
      printf("%02x (%c) %02x (%d) %02x (%c) \n", licenseCode[i+1], licenseCode[i+1], ((bitBuffer >> 10) & 0x1f) + 1, ((bitBuffer >> 10) & 0x1f) + 1, EncodeChar(bitBuffer >> 10), EncodeChar(bitBuffer >> 10));
      printf("%02x (%c) %02x (%d) %02x (%c) \n", licenseCode[i+2], licenseCode[i+2], (bitBuffer >> 5) +1, (bitBuffer >> 5) + 1, EncodeChar(bitBuffer >> 5), EncodeChar(bitBuffer >> 5));
      printf("%02x (%c) %02x (%d) %02x (%c) \n", licenseCode[i+2], licenseCode[i+3], (bitBuffer) +1, (bitBuffer) + 1, EncodeChar(bitBuffer), EncodeChar(bitBuffer));
      // printf("%02x ", licenseCode[i+1]);
      // printf("%02x ", licenseCode[i+2]);
      // printf("%02x \n", licenseCode[i+3]);
    }

    // licenseCode[LICENSE_CODE_LENGTH] = 0;
    return licenseCode;
}

int main_hack()
{
    // KeyData *keydata = LoadKeyData("mso1074z.txt");
    // uint32_t optionBits = DecodeOptionBits("CSAR");
    // LicenseData licenseData = CreateLicenseCodeInternal(optionBits, keydata);
    // uint8_t *licenseBits = EncodeLicenseCodeInternal(&licenseData, keydata);

    // char ori[] = "23456789ABCDEFGHJKLMNPQRSTUVWXYZ";
    //            // LRE8YFGHJK9SNBQ36MPVWXAZ2U47T5CD
    // // permute(ori, 0, 31, keydata, optionBits);
    // unsigned int N = 32;
    // do {
    //     strcpy(charMap, ori);

    //     if(tries % 1000000 == 0) {
    //         printf("\rTrying: %s ...", charMap);
    //         fflush(stdout);
    //         tries = 0;
    //     }
    //     tries++;
    //     char *lic = EncodeLicenseCodeInternal2(licenseBits);
    //     if(!strncmp(lic, "U2MLNYFW584R5FANJJG9VA4ZSACM", 28)) {
    //         printf("\nfound! %s %s\n", lic, charMap);
    //         // exit(0);
    //     }
    //     // if(--maxTries == 0) {
    //     //     printf("\nNo key found, sorry.\n");
    //     //     exit(0);
    //     // }
    //     free(lic);
    //     // int i;
    //     // for (i = 0; i < N; i++)
    //     //     printf("%c ", perm[i]);
    //     // printf("\n");
    // } while (perm_next(ori, N));
    // printf("\nNo key found, sorry.\n");
    // printf("%02x\n", DecodeChar('S'));
    // printf("%02x\n", (DecodeChar('S') / 2) & 0xf);
    // printf("%02X\n", ((DecodeChar('S') / 2) & 0xf) + map_20688_2[(DecodeChar('S') / 2) & 0xf]);
    
    // uint8_t licenseBits[35];
    char *licenseCode = "43RTS93WG5KUWFMC2T3GLJVHQSMU";
    // char *licenseBitsStr = lic_code_map(licenseCode);
    // printf("licenseBits1: '");
    // for(int i = 0; i < 34; i++) {
    //     licenseBits[i] = char_to_hex(licenseBitsStr[i]);
    //     printf("%02x", licenseBits[i]);
    // }

    // licenseBits[34] = 9;
    // printf("%02x", licenseBits[34]);

    // printf("' = '%s'\n", licenseBitsStr);

    // printf("---\n");

    uint8_t licenseBits[35];

    for(int i = 0, j = 0; i < LICENSE_CODE_LENGTH; i += 4, j += 5)
    {
        uint32_t bitBuffer =
            (DecodeChar(licenseCode[i]) << 15) +
            (DecodeChar(licenseCode[i+1]) << 10) +
            (DecodeChar(licenseCode[i+2]) << 5) +
            DecodeChar(licenseCode[i+3]);

        printf("i=%d, j=%d, 0x%08x ", i, j, bitBuffer);

        licenseBits[j] = bitBuffer >> 16;
        licenseBits[j+1] = (bitBuffer >> 12) & 0xf;
        licenseBits[j+2] = (bitBuffer >> 8) & 0xf;
        licenseBits[j+3] = (bitBuffer >> 4) & 0xf;
        licenseBits[j+4] = bitBuffer & 0xf;

        printf("%02x ", licenseBits[j]);
        printf("%02x ", licenseBits[j+1]);
        printf("%02x ", licenseBits[j+2]);
        printf("%02x ", licenseBits[j+3]);
        printf("%02x \n", licenseBits[j+4]);
    }

    for(int j = 0; j < 35; j+=5) {
        printf("%02x ", licenseBits[j]);
        printf("%02x ", licenseBits[j+1]);
        printf("%02x ", licenseBits[j+2]);
        printf("%02x ", licenseBits[j+3]);
        printf("%02x \n", licenseBits[j+4]);
    }

    printf("licenseBits: '");
    for(int i = 0; i < 35; i++) {
        printf("%02x", licenseBits[i]);
    }
    printf("'\n");

    
    // uint8_t* licenseBits2 = lic_to_bits(licenseCode);
    // printf("licenseBits2: '");
    // for(int i = 0; i < 35; i++) {
    //     printf("%02x ", licenseBits2[i]);
    // }
    // printf("'\n");

    // for(int j = 0; j < 35; j+=5) {
    //     printf("%02x ", licenseBits2[j]);
    //     printf("%02x ", licenseBits2[j+1]);
    //     printf("%02x ", licenseBits2[j+2]);
    //     printf("%02x ", licenseBits2[j+3]);
    //     printf("%02x \n", licenseBits2[j+4]);
    // }

    printf("%s\n", bits_to_lic(licenseBits));
    // licenseBits[34] = 9;
    // printf("%02x'\n", licenseBits[34]);

    return 0;
    KeyData *keydata = LoadKeyData("my-mso1074z.txt"); // DS1ZC163150667

    uint32_t optionBits = 0x0001C008;
    printf("\n0x%08x enc = %s\n", optionBits, EncodeOptionBits(optionBits));

    char *optionString = EncodeOptionBits(optionBits);
    char *encodedSerialNumber = keydata->serialNumber;

    uint32_t optionStringLength = strlen(optionString);
    uint32_t encodedSerialNumberLength = strlen(encodedSerialNumber);

    uint32_t signatureDataLength = (encodedSerialNumberLength);
    uint8_t *signatureData = malloc(signatureDataLength);

    memset(signatureData, 0, signatureDataLength);
    memcpy(signatureData, encodedSerialNumber, encodedSerialNumberLength);
    // memcpy(signatureData + encodedSerialNumberLength, optionString, optionStringLength);

    free(optionString);
    // free(encodedSerialNumber);


    uint8_t XXTEAKey[16];
    ParseHex(XXTEAKey, 16, keydata->XXTEAKey);
    
    printf("\n%s / %s\n", signatureData, keydata->XXTEAKey);
    for(int i = 0; i < 16; i++)
        printf("%02x", XXTEAKey[i]);
    printf("\n");

    XXTEA((uint32_t*)signatureData, signatureDataLength >> 2, (uint32_t*)XXTEAKey);


    for(int i = 0; i < signatureDataLength; i++)
        printf("%02x", signatureData[i]);
    printf("\n");

    return 0;
}
