
#include <assert.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "rigup.h"
#include "commands.h"


static int usage()
{
  puts("Usage: rigup info KEYFILE LICENSE [LICENSE...]");
  puts("");
  puts("Print detailed license information.");
  puts("");
  puts("    KEYFILE     Keyfile containing keys and serial number.");
  puts("    LICENSE     One or more license codes to show detailed info.");
  puts("");
  return 0;
}


int main_licenseinfo(int argc, char *argv[])
{
  if (argc < 3)
    return usage();

  const char *keyfilename = argv[1];

  KeyData *keydata = LoadKeyData(keyfilename);
  if (!keydata)
  {
    fprintf(stderr, "Loading keyfile '%s' failed.\n", keyfilename);
    return 1;
  }

  for (int i = 2; i < argc; ++i)
  {
    char *licenseCode = CompactLicenseCode(argv[i]);
    PrintLicenseInfo(licenseCode, keydata);
    puts("");
    free(licenseCode);
  }

  free(keydata);
  return 0;
}
