
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include "rigup.h"
#include "commands.h"


struct Entry
{
  char		*device;
  char		*options;
  char		*description;
};

struct Entry entries[] =
{
  { "ds2072a",	"NSEH",	"All options, no bandwidth upgrade" },
  { "ds2072a",	"NSER",	"All options, bandwidth 100 MHz" },
  { "ds2072a",	"NSEQ",	"All options, bandwidth 200 MHz" },
  { "ds2072a",	"NS8H",	"All options, bandwidth 300 MHz" },

  { "ds2102a",	"NSEH",	"All options, no bandwidth upgrade" },
  { "ds2102a",	"NSEQ",	"All options, bandwidth 200 MHz" },
  { "ds2102a",	"NS8H",	"All options, bandwidth 300 MHz" },

  { "ds2202a",	"NSEH",	"All options, no bandwidth upgrade" },
  { "ds2202a",	"NS8H",	"All options, bandwidth 300 MHz" },
  
  { "ds2302a",	"NSEH",	"All options, no bandwidth upgrade" },

  { 0, 0, 0 }
};


int usage_luxury()
{
  puts("Usage: rigup MODEL DUMPFILE");
  puts("");
  puts("Creates a set of licenses suitable for the given model.");
  puts("Needs a memory dump of the DRAM from the specific");
  puts("device to create the licenses.");
  puts("");
  puts("    MODEL       One of DS2072A, DS2102A, DS2202A or DS2302A");
  puts("    DUMPFILE    Binary file containing a memory dump");
  puts("");
  puts("Example:");
  puts("");
  puts("    rigup ds2072a memory_dump.bin");
  puts("");

  return 0;
}


int main_luxury(int argc, char *argv[])
{
  if (argc != 2)
    return usage_luxury();

  const char *device = argv[0];
  const char *dump_filename = argv[1];

  size_t datalen;
  void *data = LoadBinary(&datalen, dump_filename);
  if (!data)
  {
    fprintf(stderr, "Loading memory dump '%s' failed\n", dump_filename);
    return 1;
  }

  KeyData *keydata = ScanKeys(data, datalen);
  free(data);

  if (!keydata)
  {
    fprintf(stderr, "Scanning '%s' failed: No keys\n", dump_filename);
    return 1;
  }

  BreakECDS(keydata->privateKey, keydata->publicKey);

  printf("Serial number: %s\n\n", keydata->serialNumber);

  for (struct Entry *e = entries; e->device; ++e)
    if (strcasecmp(device, e->device) == 0)
    {
      uint32_t optionBits = DecodeOptionBits(e->options);
      char *licenseCode = CreateLicenseCode(optionBits, keydata);
      char *pretty = PrettyLicenseCode(licenseCode);

      printf("%s:  %s    %s\n", e->options, pretty, e->description);

      free(pretty);
      free(licenseCode);
    }

  puts("");

  free(keydata);
  return 0;
}
