
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include "miracl/miracl.h"
#include "commands.h"


static int usage()
{
  usage_luxury();
  puts("");
  puts("Available expert commands are: (omit parameters for help)");
  puts("");
  puts("    rigup scan [KEYFILE] MEMORYDUMP");
  puts("    rigup serial KEYFILE SERIALNUMBER");
  puts("    rigup license KEYFILE OPTIONS");
  puts("    rigup info KEYFILE LICENSE");
  puts("    rigup search [KEYFILE] MEMORYDUMP");
  puts("    rigup break PUBLICKEY");
  puts("    rigup riglol ...");
  puts("");
  return 0;
}


struct entry
{
  char *name;
  int (*func)(int argc, char *argv[]);
};


static struct entry commands[] =
{
  { "scan",		main_scankeys },
  { "serial",		main_setserial },
  { "setserial",	main_setserial },
  { "license",		main_createlicense },
  { "info",   main_licenseinfo },
  { "hack",		main_hack },
  { "search",		main_scanlicense },
  { "break",		main_breakecds },
  { "ds2072a",		main_luxury },
  { "ds2102a",		main_luxury },
  { "ds2202a",		main_luxury },
  { "ds2302a",		main_luxury },
  { "riglol",		main_riglol },
  { 0, 0, }
};

int main(int argc, char *argv[])
{
  mirsys(800, 16)->IOBASE = 16;

  if (argc < 2)
  {
    printf("rigup - Version %s\n", RIGUP_VERSION);
    printf("        Hacked up for MSO1000Z(-S) rmd79, 0ff eevblog.com\n\n");
    return usage();
  }

  const char *cmd = argv[1];

  argc--;
  argv = &(argv[1]);

  for (struct entry *e = commands; e->name; ++e)
    if (strcasecmp(cmd, e->name) == 0)
    {
      if (strcasecmp(cmd, "riglol") != 0) {
        printf("rigup %s - Version %s\n\n", e->name, RIGUP_VERSION);
        printf("        Hacked up for MSO1000Z(-S) rmd79, 0ff eevblog.com\n\n");
      }
      return e->func(argc, argv);
    }

  fprintf(stderr, "Unknown command. Try without arguments.\n");
  return 1;
}


