#ifndef RIGUP_H
#define RIGUP_H

#include <inttypes.h>


#define LICENSE_CODE_LENGTH	28
#define KEYDATA_FIELDSIZE	64


typedef struct
{
  char    RC5Key1[KEYDATA_FIELDSIZE];		// hex
  char    RC5Key2[KEYDATA_FIELDSIZE];		// hex
  char    XXTEAKey[KEYDATA_FIELDSIZE];		// hex
  char    publicKey[KEYDATA_FIELDSIZE];		// hex
  char    privateKey[KEYDATA_FIELDSIZE];	// hex
  char    serialNumber[KEYDATA_FIELDSIZE];	// ASCII
} KeyData;

typedef struct
{
  uint32_t	optionBits;
  uint64_t	sig1;
  uint64_t	sig2;
  uint64_t	pad1;
  uint64_t	pad2;
} LicenseData;


extern uint32_t DecodeChar(char value);
extern uint64_t DecodeSignature(uint64_t value);
extern int DecodeLicenseCode(LicenseData *LicenseData, const char *licenseCode, const KeyData *keydata);
extern char* EncodeOptionBits(uint32_t optionBits);

extern char* EncodeSerialNumber(KeyData *keydata);
// extern char* EncodeSerialNumber(const char *serialNumber);
extern char *lic_code_map(char *lic_skipped);

extern void XXTEA(uint32_t *v, int n, uint32_t const key[4]);
extern uint64_t ByteSwap64(uint64_t value);
extern int VerifySignature(uint64_t sig1, uint64_t sig2, uint8_t signatureDataHash[20], const char *publicKey);
extern int VerifyLicenseCode(const char *licenseCode, const KeyData *keydata);
extern void PrintLicenseInfo(const char *licenseCode, const KeyData *keydata);

extern char EncodeChar(uint32_t value);
extern uint64_t EncodeSignature(uint64_t sig);
extern char * EncodeLicenseCode(const LicenseData *licenseData, const KeyData *keydata);
extern uint32_t DecodeOptionBits(const char *optionString);
extern char * DecodeSerialNumber(const char *serialNumber);
extern void CreateSignature(uint64_t *sig1, uint64_t *sig2, uint8_t signatureDataHash[20], const char *privateKey);
extern char * CreateLicenseCode(uint32_t optionBits, const KeyData *keydata);
extern char * PrettyLicenseCode(const char *licenseCode);
extern char * CompactLicenseCode(const char *licenseCode);

extern uint8_t* EncodeLicenseCodeInternal(const LicenseData *licenseData, const KeyData *keydata);
extern char * EncodeLicenseCodeInternal2(uint8_t* licenseBits);
extern LicenseData CreateLicenseCodeInternal(uint32_t optionBits, const KeyData *keydata);


extern KeyData * LoadKeyData(const char *filename);
extern int SaveKeyData(const char *filename, const KeyData* data);
extern void PrintKeyData(const KeyData* data);
extern char * FormatHex(char *out, const uint8_t *bytes, const size_t len);
extern size_t ParseHex(uint8_t *buffer, const size_t len, const char *hexstring);
extern int IsValidHex(const char* hexstring, const size_t len);
extern void * LoadBinary(size_t *length, const char *filename);
extern KeyData* ScanKeys(const void *data, size_t datasize);

extern char * BreakECDS(char *privateKey, const char *publicKey);

#endif // RIGUP_H
