
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include "miracl/miracl.h"
#include "rigup.h"


static void usage()
{
  puts("Usage: rigup scan [KEYFILE] DUMPFILE");
  puts("");
  puts("Scans for several keys needed for the keygen to work");
  puts("and saves them optionally to a file.");
  puts("");
  puts("    KEYFILE       optional file to save keys into");
  puts("    DUMPFILE      binary file containing memory dump");
  puts("");
  exit(0);
}


int main_scankeys(int argc, char *argv[])
{
  const char *dump_filename = 0;;
  const char *keys_filename = 0;

  switch (argc)
  {
    case 2:
      dump_filename = argv[1];
      break;

    case 3:
      keys_filename = argv[1];
      dump_filename = argv[2];
      break;

    default:
      usage();
  }

  size_t datalen;
  void *data = LoadBinary(&datalen, dump_filename);
  if (!data)
  {
    fprintf(stderr, "Loading memory dump '%s' failed\n", dump_filename);
    return 1;
  }

  KeyData *keydata = ScanKeys(data, datalen);
  free(data);

  if (!keydata)
  {
    fprintf(stderr, "Scanning '%s' failed: No keys\n", dump_filename);
    return 1;
  }

  BreakECDS(keydata->privateKey, keydata->publicKey);

  if (keys_filename && !SaveKeyData(keys_filename, keydata))
    fprintf(stderr, "Saving keyfile '%s' failed!\n", keys_filename);

  PrintKeyData(keydata);
  puts("");

  free(keydata);
  return 0;
}
