
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "rigup.h"
#include "commands.h"


static void usage()
{
  puts("Usage: rigup serial KEYFILE SN");
  puts("");
  puts("Change or set the serial number in a keyfile.");
  puts("");
  puts("    KEYFILE       keyfile to change");
  puts("    SN            new serial number to set");
  puts("");
  exit(0);
}


int main_setserial(int argc, char *argv[])
{
  if (argc != 3)
    usage();

  const char *keysFilename = argv[1];
  const char *serialNumber = argv[2];

  // TODO check serial length?

  // Load
  KeyData *keydata = LoadKeyData(keysFilename);
  if (!keydata)
  {
    printf("Loading keyfile '%s' failed!\n", keysFilename);
    return 1;
  }

  // Set serial number upper case
  strcpy(keydata->serialNumber, serialNumber);
  for (char *p = keydata->serialNumber; *p; ++p)
    *p = toupper(*p);

  // Save
  if (!SaveKeyData(keysFilename, keydata))
  {
    printf("Saving keyfile '%s' failed!\n", keysFilename);
    return 1;
  }

  PrintKeyData(keydata);
  puts("");

  return 0;
}
