/*
 * Original coded by Cnbragon[iPB][RCT][TT]
 *
 * All credits belong to him. Heavily modified for the rigup keygen.
 *
 * Original history:
 *
 * ECDLP Solver pollard's pho method
 * v0.1 implemented the original algorithm 4.3
 * v0.2 changed Branches L to 32
 * v0.3 some codes optimized
 * v0.4 changed Floyd's cycleing finding algorithm to Brent's improved cycle algorithm,more faster
 * v0.5 implemented Pohlig-Hellman algorithm,much more faster
 * v0.6 fixed the pollard's pho method failded bug
 */

#include <assert.h>
#include <time.h>
#include <stdlib.h>
#include "miracl/miracl.h"
#include "rigup.h"


// ECC parameters
static char A[] = "2982";
static char B[] = "3408";
static char P[] = "AEBF94CEE3E707";
static char N[] = "AEBF94D5C6AA71";
static char Gx[] = "7A3E808599A525";
static char Gy[] = "28BE7FAFD2A052";
static char Factor_1[] = "11";
static char Factor_2[] = "35";
static char Factor_3[] = "DD0F5";
static char Factor_4[] = "397FAE9";



#define WALK_BRANCHES 32
#define MAX_PRIMES    256

typedef struct ECDLP_Solver
{
	big es_a;
	big es_b;
	big es_p;
	big es_order;
	epoint* es_ptp;
	epoint* es_ptq;
}ECDLP_Instance;

typedef struct Pohlig_Hellman_EC
{
	ECDLP_Instance Pohell_status;
	big phe_spf[MAX_PRIMES];            /* small prime factors */
	int phe_nspf;                       /* number of small prime factors */
	int phe_c[MAX_PRIMES];              /* exponents of each factor */
}PHE_Instance;

static void Solver_ECDLP_Init(ECDLP_Instance* ecdlpinst, char *publicKey);
static void Pohlig_Hellman_EC_Init(ECDLP_Instance ecdlpinst, PHE_Instance* pheinst);
static big Pollard_Pho_EC_Compute(big order_of_basepoint, epoint* base_point, epoint* public_point);
static big Pohlig_Hellman_EC_Compute(PHE_Instance pheinst);


static big Pollard_Pho_EC_Compute(big order_of_basepoint, epoint* base_point, epoint* public_point)
{
	big big_branches;
	big big_c1,big_c2,big_d1,big_d2;
	big big_x,big_temp,big_log;
	big big_k,big_j,big_r;
	int j=0;
	big a[WALK_BRANCHES],b[WALK_BRANCHES];
	epoint* R[WALK_BRANCHES], *ept_X1, *ept_X2;
	BOOL bDone=FALSE;

	big_branches=mirvar(4);
	big_c1=mirvar(0);
	big_c2=mirvar(0);
	big_d1=mirvar(0);
	big_d2=mirvar(0);
	big_x=mirvar(0);
	big_temp=mirvar(0);
	big_log=mirvar(0);
	big_j=mirvar(0);
	big_k=mirvar(0);
	big_r=mirvar(1);

	irand((unsigned int)time(0)); // irand(GetTickCount());
	for (j=0;j<WALK_BRANCHES;j++)
	{
		a[j]=mirvar(0);
		b[j]=mirvar(0);
		R[j]=epoint_init();
	}
	ept_X1=epoint_init();
	ept_X2=epoint_init();
	while (1)
	{
		for (j=0;j<WALK_BRANCHES;j++)
		{
			bigrand(order_of_basepoint,a[j]);
			bigrand(order_of_basepoint,b[j]);
			ecurve_mult2(a[j],base_point,b[j],public_point,R[j]);
		}
		bigrand(order_of_basepoint,big_c1);
		bigrand(order_of_basepoint,big_d1);
		ecurve_mult2(big_c1,base_point,big_d1,public_point,ept_X1);
		do
		{
			copy(big_c1,big_c2);
			copy(big_d1,big_d2);
			epoint_copy(ept_X1,ept_X2);
			copy(big_k,big_j);
			add(big_r,big_r,big_r);
			do
			{
				incr(big_k,1,big_k);
				epoint_get(ept_X1,big_x,big_x);
				j=remain(big_x,WALK_BRANCHES);
				ecurve_add(R[j],ept_X1);
				add(big_c1,a[j],big_c1);
				divide(big_c1,order_of_basepoint,order_of_basepoint);
				add(big_d1,b[j],big_d1);
				divide(big_d1,order_of_basepoint,order_of_basepoint);
				if (epoint_comp(ept_X1,ept_X2)==TRUE)
				{
					bDone=TRUE;
				}
			} while((bDone==FALSE)&&(mr_compare(big_k,big_r)<0));
		} while(bDone==FALSE);
		if (mr_compare(big_d2,big_d1)==0)
		{
			continue;
		}
		else
		{
			divide(big_c1,order_of_basepoint,order_of_basepoint);
			divide(big_c2,order_of_basepoint,order_of_basepoint);
			subtract(big_d2,big_d1,big_temp);
			divide(big_temp,order_of_basepoint,order_of_basepoint);
			xgcd(big_temp,order_of_basepoint,big_temp,big_temp,big_temp);
			subtract(big_c1,big_c2,big_log);
			divide(big_log,order_of_basepoint,order_of_basepoint);
			multiply(big_log,big_temp,big_log);
			divide(big_log,order_of_basepoint,order_of_basepoint);
			if (size(big_log)<0)
			{
				add(big_log,order_of_basepoint,big_log);
			}
			ecurve_mult(big_log,base_point,ept_X1);
			if (epoint_comp(ept_X1,public_point)==TRUE)
			{
				//cotnum(big_log,stdout);
				break;
			}
			else
			{
				zero(big_log);
				continue;
				//printf("Error... :(,please send your Elliptic Curve parameters to cnbragon@gmail.com\n");
			}
			//break;
		}
	}
	/*do
	{
		epoint_get(ept_X1,big_x,big_x);
		j=remain(big_x,WALK_BRANCHES);
		ecurve_add(R[j],ept_X1);
		incr(x1[j],1,x1[j]);
		for (i=0;i<2;i++)
		{
			epoint_get(ept_X2,big_x,big_x);
			j=remain(big_x,WALK_BRANCHES);
			ecurve_add(R[j],ept_X2);
			incr(x2[j],1,x2[j]);
		}
#ifdef TEST
		epoint_get(ept_X1,x,y);
		printf("x1=(");
		cotnum(x,stdout);
		cotnum(y,stdout);
		printf(")\n");
		epoint_get(ept_X2,x,y);
		printf("x2=(");
		cotnum(x,stdout);
		cotnum(y,stdout);
		printf(")\n");
		cotnum(big_d1,stdout);
		cotnum(big_d2,stdout);
#endif
	} while(epoint_comp(ept_X1,ept_X2)==FALSE);*/

	mirkill(big_temp);
	mirkill(big_x);
	mirkill(big_branches);
	mirkill(big_c1);
	mirkill(big_c2);
	mirkill(big_d1);
	mirkill(big_d2);
	for (j=0;j<4;j++)
	{
		mirkill(a[j]);
		mirkill(b[j]);
		epoint_free(R[j]);
	}
	return big_log;
}


static big Pohlig_Hellman_EC_Compute(PHE_Instance pheinst)
{
	int i=0,j=0;
	epoint *pt_Q0, *pt_Q1, *pt_P0, *pt_P1;
	big big_log,big_T0,big_T1,big_T2,big_order0;
	big big_a[MAX_PRIMES],big_x[MAX_PRIMES],big_moduli[MAX_PRIMES];
	big_chinese crt1;

	pt_Q0=epoint_init();
	pt_Q1=epoint_init();
	pt_P0=epoint_init();
	pt_P1=epoint_init();

	big_T0=mirvar(0);
	big_T1=mirvar(0);
	big_T2=mirvar(0);
	big_order0=mirvar(0);

	copy(pheinst.Pohell_status.es_order,big_order0);

	for (i=0;i<pheinst.phe_nspf;i++)
	{
		j=0;
		big_x[i]=mirvar(0);
		epoint_copy(pheinst.Pohell_status.es_ptq,pt_Q0);

		copy(big_order0,big_T0);
		divide(big_T0,pheinst.phe_spf[i],big_T0);
		ecurve_mult(big_T0,pheinst.Pohell_status.es_ptp,pt_P0);

		while (j<pheinst.phe_c[i])
		{
			power(pheinst.phe_spf[i],(j+1),big_T1,big_T1);
			copy(big_order0,big_T2);
			divide(big_T2,big_T1,big_T2);
			ecurve_mult(big_T2,pt_Q0,pt_Q1);
			big_a[j]=mirvar(0);
			big_a[j]=Pollard_Pho_EC_Compute(pheinst.phe_spf[i],pt_P0,pt_Q1);
			power(pheinst.phe_spf[i],j,big_T1,big_T1);
			multiply(big_a[j],big_T1,big_T1);
			add(big_T1,big_x[i],big_x[i]);
			ecurve_mult(big_T1,pheinst.Pohell_status.es_ptp,pt_P1);
			ecurve_sub(pt_P1,pt_Q0);
			mirkill(big_a[j]);
			j++;
		}
	}

	// Chinese Remainder Theorem...
	big_log=mirvar(0);
	for (i=0;i<pheinst.phe_nspf;i++)
	{
		power(pheinst.phe_spf[i],pheinst.phe_c[i],big_T0,big_T0);
		big_moduli[i]=mirvar(0);
		copy(big_T0,big_moduli[i]);
	}
	crt_init(&crt1,pheinst.phe_nspf,big_moduli);
	crt(&crt1,big_x,big_log);
	crt_end(&crt1);

	epoint_free(pt_Q0);
	epoint_free(pt_Q1);
	epoint_free(pt_P0);
	epoint_free(pt_P1);

	mirkill(big_T0);
	mirkill(big_T1);
	mirkill(big_T2);
	mirkill(big_order0);

	return big_log;
}


static void Solver_ECDLP_Init(ECDLP_Instance* ecdlpinst, char *publicKey)
{
	const int lsb = 1;
	big big_a,big_b,big_p,big_order;
	big big_px,big_py,big_qx,big_qy;
	epoint *ept_P, *ept_Q;

	big_a=mirvar(0);
	big_b=mirvar(0);
	big_p=mirvar(0);

	cinstr(big_a, A);
	ecdlpinst->es_a=mirvar(0);
	copy(big_a,ecdlpinst->es_a);

	cinstr(big_b, B);
	ecdlpinst->es_b=mirvar(0);
	copy(big_b,ecdlpinst->es_b);

	cinstr(big_p, P);
	ecdlpinst->es_p=mirvar(0);
	copy(big_p,ecdlpinst->es_p);

	ecurve_init(big_a,big_b,big_p,MR_PROJECTIVE);

	big_px=mirvar(0);
	big_py=mirvar(0);

	cinstr(big_px, Gx);
	cinstr(big_py, Gy);

	ept_P=epoint_init();
	epoint_set(big_px,big_px, remain(big_py, 2) ,ept_P);
	ecdlpinst->es_ptp=epoint_init();
	epoint_copy(ept_P,ecdlpinst->es_ptp);

	mirkill(big_px);
	mirkill(big_py);
	epoint_free(ept_P);

	big_order=mirvar(0);

	cinstr(big_order, N);
	ecdlpinst->es_order=mirvar(0);
	copy(big_order,ecdlpinst->es_order);
	mirkill(big_order);

	big_qx=mirvar(0);
	big_qy=mirvar(0);
	cinstr(big_qx, publicKey);

	ept_Q=epoint_init();
	epoint_set(big_qx,big_qx,lsb,ept_Q);
	ecdlpinst->es_ptq=epoint_init();
	epoint_copy(ept_Q,ecdlpinst->es_ptq);

	mirkill(big_qx);
	mirkill(big_qy);
	epoint_free(ept_Q);
	mirkill(big_a);
	mirkill(big_b);
	mirkill(big_p);
}


static void Pohlig_Hellman_EC_Init(ECDLP_Instance ecdlpinst, PHE_Instance* pheinst)
{
	big bg_spf[MAX_PRIMES]; /* stores the small prime factors */

	pheinst->Pohell_status.es_a=mirvar(0);
	pheinst->Pohell_status.es_b=mirvar(0);
	pheinst->Pohell_status.es_p=mirvar(0);
	pheinst->Pohell_status.es_order=mirvar(0);
	pheinst->Pohell_status.es_ptp=epoint_init();
	pheinst->Pohell_status.es_ptq=epoint_init();
	copy(ecdlpinst.es_a,pheinst->Pohell_status.es_a);
	copy(ecdlpinst.es_b,pheinst->Pohell_status.es_b);
	copy(ecdlpinst.es_p,pheinst->Pohell_status.es_p);
	copy(ecdlpinst.es_order,pheinst->Pohell_status.es_order);
	epoint_copy(ecdlpinst.es_ptp,pheinst->Pohell_status.es_ptp);
	epoint_copy(ecdlpinst.es_ptq,pheinst->Pohell_status.es_ptq);

	pheinst->phe_nspf = 4;

	bg_spf[0]=mirvar(0);
	pheinst->phe_spf[0]=mirvar(0);
	cinstr(bg_spf[0], Factor_1);
	copy(bg_spf[0],pheinst->phe_spf[0]);
	pheinst->phe_c[0] = 1;

	bg_spf[1]=mirvar(0);
	pheinst->phe_spf[1]=mirvar(0);
	cinstr(bg_spf[1], Factor_2);
	copy(bg_spf[1],pheinst->phe_spf[1]);
	pheinst->phe_c[1] = 1;

	bg_spf[2]=mirvar(0);
	pheinst->phe_spf[2]=mirvar(0);
	cinstr(bg_spf[2], Factor_3);
	copy(bg_spf[2],pheinst->phe_spf[2]);
	pheinst->phe_c[2] = 1;

	bg_spf[3]=mirvar(0);
	pheinst->phe_spf[3]=mirvar(0);
	cinstr(bg_spf[3], Factor_4);
	copy(bg_spf[3],pheinst->phe_spf[3]);
	pheinst->phe_c[3] = 1;
}


char * BreakECDS(char *privateKey, const char *publicKey)
{
	assert( publicKey );

	if (!privateKey)
	  privateKey = malloc(17);	// 8 byte = 16 hex-digits + null terminator

	ECDLP_Instance ecdlp1;
	Solver_ECDLP_Init(&ecdlp1, (char *)publicKey);
	assert( !isprime(ecdlp1.es_order) );

	PHE_Instance phe1;
	Pohlig_Hellman_EC_Init(ecdlp1,&phe1);

	big logarithm = Pohlig_Hellman_EC_Compute(phe1);

	uint8_t bytes[8];
	big_to_bytes(8, logarithm, (char *)&bytes, 1);

	return FormatHex(privateKey, bytes, 8);
}
